/*
 * Ʈ: TLE2Framework
 * ϸ: DefaultAAManager.java
 * ۼ: 2004. 11. 10
 */
package tle.framework.component.impl.aamanager;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import tle.framework.component.ComponentConfig;
import tle.framework.component.ComponentException;
import tle.framework.component.impl.ComponentBase;
import tle.framework.component.spi.aamanager.AAManager;
import tle.framework.component.spi.aamanager.AAManagerException;
import tle.framework.component.spi.aamanager.AAManagerProxy;
import tle.framework.component.spi.aamanager.AuthenticationException;
import tle.framework.component.spi.aamanager.NullService;
import tle.framework.component.spi.aamanager.NullUser;
import tle.framework.component.spi.aamanager.Role;
import tle.framework.component.spi.aamanager.Service;
import tle.framework.component.spi.aamanager.User;
import tle.framework.component.spi.aamanager.UserAuthenticationInfo;
import tle.framework.component.spi.ra.RequestInfo;

/**
 * AAManager ⺻ ü Ŭμ, RoleManager, ServiceManager, 
 * SessionManager, UserManager, Authenticator Ͽ  .
 * <p>
 *  ̽  Ŭ  Ʈ ʱȭ Ķ͸ ؼ Ѵ.
 * <ul>
 *   <li>RoleManager - RoleManager ü Ŭ  ̸
 *   <li>ServiceManager - ServiceManager ü Ŭ  ̸
 *   <li>SessionManager - SessionManager ü Ŭ  ̸
 *   <li>UserManager - UserManager ü Ŭ  ̸
 *   <li>Authenticator - Authenticator ü Ŭ  ̸
 * </ul>
 * 
 * DefaultAAManager    5 ̽  Ŭ ʿϸ
 * Ÿ Role, Service, User  Ŭ ʿϴ.
 * DefaultAAManager AAManager      ֵ ϱ ؼ 
 *  5 ̽   3 ⺻ ְ ִ.
 * <ul>
 *   <li>tle.framework.component.impl.aamanager.role.RoleManagerImpl
 *   <li>tle.framework.component.impl.aamanager.service.ServiceManagerImpl
 *   <li>tle.framework.component.impl.aamanager.session.SessionManagerImpl
 * </ul>
 * RoleManagerImpl ServiceManagerImpl Role Service ü ϰ ֱ ,
 *  3 ⺻ ü   DefaultAAManager ڴ UserManager Authenticator
 * ü ָ ȴ.
 *   
 * @author ֹ
 * @since 2.0
 * @see tle.framework.component.impl.aamanager.RoleManager
 * @see tle.framework.component.impl.aamanager.ServiceManager
 * @see tle.framework.component.impl.aamanager.SessionManager
 * @see tle.framework.component.impl.aamanager.UserManager
 * @see tle.framework.component.impl.aamanager.Authenticator
 */
public class DefaultAAManager extends ComponentBase implements AAManager, DefaultAAManagerMBean {
	private AAManagerProxy proxy;
	
	private RoleManager roleManager;
	private ServiceManager serviceManager;
	private SessionManager sessionManager;
	private UserManager userManager;
	private Authenticator authenticator;
	
	/**
	 * RoleManage, ServiceManager, SessionManager, UserManager, Authenticator
	 * νϽ Ѵ.
	 * 
	 * @see tle.framework.component.impl.ComponentBase#initing(tle.framework.component.ComponentConfig)
	 */
	protected void initing(ComponentConfig config) throws ComponentException {
		String roleManagerClassName = config.getInitParameter("RoleManager");
		String serviceManagerClassName = config.getInitParameter("ServiceManager");
		String sessionManagerClassName = config.getInitParameter("SessionManager");
		String userManagerClassName = config.getInitParameter("UserManager");
		String authenticatorClassName = config.getInitParameter("Authenticator");
		
		try {
			Class roleManagerClass = Class.forName(roleManagerClassName);
			RoleManager roleManagerInstance = (RoleManager)roleManagerClass.newInstance();
			roleManagerInstance.init(config);
			roleManager = roleManagerInstance; 
		} catch(Throwable e) {
			throw new ComponentException(e.getMessage(), e);
		}

		try {
			Class serviceManagerClass = Class.forName(serviceManagerClassName);
			ServiceManager serviceManagerInstance = (ServiceManager)serviceManagerClass.newInstance();
			serviceManagerInstance.init(config);
			serviceManager = serviceManagerInstance; 
		} catch(Throwable e) {
			throw new ComponentException(e.getMessage(), e);
		}

		try {
			Class sessionManagerClass = Class.forName(sessionManagerClassName);
			SessionManager sessionManagerInstance = (SessionManager)sessionManagerClass.newInstance();
			sessionManagerInstance.init(config);
			sessionManager = sessionManagerInstance; 
		} catch(Throwable e) {
			throw new ComponentException(e.getMessage(), e);
		}

		try {
			Class authenticatorClass = Class.forName(authenticatorClassName);
			Authenticator authenticatorInstance = (Authenticator)authenticatorClass.newInstance();
			authenticatorInstance.init(config);
			authenticator = authenticatorInstance; 
		} catch(Throwable e) {
			throw new ComponentException(e.getMessage(), e);
		}

		try {
			Class userManagerClass = Class.forName(userManagerClassName);
			UserManager userManagerInstance = (UserManager)userManagerClass.newInstance();
			userManagerInstance.init(config);
			userManager = userManagerInstance; 
		} catch(Throwable e) {
			throw new ComponentException(e.getMessage(), e);
		}
		proxy = new AAManagerProxy(this);
	}
	
	/**
	 * Authenticator.authenticate() ޼ҵ带 ȣϿ θ óѴ.
	 *   userManager.getUser() ޼ҵ带 Ͽ    Ѵ.
	 * 
	 * @throws AuthenticationException ̵ ȣ  ߸Ǿ    ߻Ѵ.
	 * @throws AAManagerException 
	 * @see tle.framework.component.spi.aamanager.AAManager#authenticate(tle.framework.component.spi.aamanager.UserAuthenticationInfo)
	 */
	public User authenticate(UserAuthenticationInfo authInfo) throws AAManagerException {
		authenticator.authenticate(authInfo);
		return userManager.getUser(authInfo);
	}
	
	/**
	 * SessionManager.openSession() ޼ҵ带 Ͽ  Ѵ.
	 * 
	 * @see tle.framework.component.spi.aamanager.AAManager#openSession(tle.framework.component.spi.aamanager.User, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void openSession(User user, HttpServletRequest request, HttpServletResponse response) throws AAManagerException {
		sessionManager.openSession(user, request, response);
	}

	/**
	 * SessionManager.closeSession() ޼ҵ带 Ͽ  Ѵ.
	 * 
	 * @see tle.framework.component.spi.aamanager.AAManager#closeSession(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	public void closeSession(HttpServletRequest request, HttpServletResponse response) throws AAManagerException {
		sessionManager.closeSession(request, response);
	}

	/**
	 * SessionManager.getSessionUser() ޼ҵ带 Ͽ  ڸ Ѵ.
	 *    NullUser.instance Ѵ.
	 * 
	 * @see tle.framework.component.spi.aamanager.AAManager#getSessionUser(javax.servlet.http.HttpServletRequest)
	 */
	public User getSessionUser(HttpServletRequest request) throws AAManagerException {
		User user = sessionManager.getSessionUser(request);
		if (user == null) return NullUser.intance;
		return user;
	}
	
	/**
	 * ServiceManager.hasGrant() ޼ҵ带 Ͽ   θ ǴѴ.
	 *  
	 * @see tle.framework.component.spi.aamanager.AAManager#checkAuthorization(tle.framework.component.spi.aamanager.User, tle.framework.component.spi.aamanager.Service)
	 */
	public boolean checkAuthorization(User user, Service service)
			throws AAManagerException {
		Role[] roles = user.getRoles();
		if (roles != null) {
			for (int i = 0 ; i < roles.length ; i++) {
				if (serviceManager.hasGrant(roles[i], service)) {
					return true;
				}
			}
		}
		return false;
	}
	
	/**
	 * ServiceManager.getService() ޼ҵ带 Ͽ Service Ѵ.
	 * ServiceManager.getService() ޼ҵ尡 null ϸ
	 * NullService Ѵ.
	 * 
	 * @see tle.framework.component.spi.aamanager.AAManager#getService(tle.framework.component.spi.ra.RequestInfo)
	 */
	public Service getService(RequestInfo requestInfo)
			throws AAManagerException {
		Service service = serviceManager.getService(requestInfo);
		if (service == null) {
			return NullService.intance;
		}
		return service;
	}
	
	/**
	 * RoleManager.getRole() ޼ҵ带 Ͽ Role Ѵ.
	 * 
	 * @see tle.framework.component.spi.aamanager.AAManager#getRole(java.lang.String)
	 */
	public Role getRole(String roleID) throws AAManagerException {
		return roleManager.getRole(roleID);
	}
	
	/**
	 * @see tle.framework.component.spi.aamanager.AAManager#getAAManagerProxy()
	 */
	public AAManagerProxy getAAManagerProxy() {
		return proxy;
	}

	public String getRoleManagerClassName() {
		return roleManager.getClass().getName();
	}

	public String getServiceManagerClassName() {
		return serviceManager.getClass().getName();
	}

	public String getSessionManagerClassName() {
		return sessionManager.getClass().getName();
	}

	public String getUserManagerClassName() {
		return userManager.getClass().getName();
	}

	public String getAuthenticatorClassName() {
		return authenticator.getClass().getName();
	}

	public void reloadServiceConfiguration() throws AAManagerException {
		serviceManager.reloadConfiguration(config);
	}
}
