/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularType;

public class OpenMBeanAttributeInfoSupport
extends MBeanAttributeInfo
implements OpenMBeanAttributeInfo,
Serializable {
    private static final long serialVersionUID = -4867215622149721849L;
    private OpenType openType;
    private Object defaultValue = null;
    private Set legalValues = null;
    private Comparable minValue = null;
    private Comparable maxValue = null;
    private transient int hashCode = 0;
    private transient String toStringName = null;

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs) {
        super(name, openType == null ? "" : openType.getClassName(), description, isReadable, isWritable, isIs);
        if (openType == null) {
            throw new IllegalArgumentException("OpenType can't be null");
        }
        if (name == null || name.length() == 0 || name.trim().equals("")) {
            throw new IllegalArgumentException("name can't be null or empty");
        }
        if (description == null || description.length() == 0 || description.trim().equals("")) {
            throw new IllegalArgumentException("description can't be null or empty");
        }
        this.openType = openType;
    }

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs, Object defaultValue) throws OpenDataException {
        this(name, description, openType, isReadable, isWritable, isIs);
        if ((openType instanceof ArrayType || openType instanceof TabularType) && defaultValue != null) {
            throw new OpenDataException("defaultValue is not supported for ArrayType and TabularType. Should be null");
        }
        if (defaultValue != null && !openType.isValue(defaultValue)) {
            throw new OpenDataException("defaultValue is not a valid value for the given OpenType");
        }
        this.defaultValue = defaultValue;
    }

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs, Object defaultValue, Object[] legalValues) throws OpenDataException {
        this(name, description, openType, isReadable, isWritable, isIs, defaultValue);
        if (openType instanceof ArrayType || openType instanceof TabularType) {
            if (legalValues != null && legalValues.length > 0) {
                throw new OpenDataException("legalValues isn't allowed for ArrayType and TabularType. Should be null or empty array");
            }
        } else if (legalValues != null && legalValues.length > 0) {
            HashSet<Object> tmpSet = new HashSet<Object>(legalValues.length, 1.0f);
            for (int i = 0; i < legalValues.length; ++i) {
                Object lv = legalValues[i];
                if (!openType.isValue(lv)) {
                    throw new OpenDataException("An Entry in the set of legalValues is not a valid value for the given opentype");
                }
                tmpSet.add(lv);
            }
            if (defaultValue != null && !tmpSet.contains(defaultValue)) {
                throw new OpenDataException("The legal value set must include the default value");
            }
            this.legalValues = Collections.unmodifiableSet(tmpSet);
        }
    }

    public OpenMBeanAttributeInfoSupport(String name, String description, OpenType openType, boolean isReadable, boolean isWritable, boolean isIs, Object defaultValue, Comparable minValue, Comparable maxValue) throws OpenDataException {
        this(name, description, openType, isReadable, isWritable, isIs, defaultValue);
        if (minValue != null && !openType.isValue(minValue)) {
            throw new OpenDataException("minValue is not a valid value for the specified openType");
        }
        if (maxValue != null && !openType.isValue(maxValue)) {
            throw new OpenDataException("maxValue is not a valid value for the specified openType");
        }
        if (minValue != null && maxValue != null && minValue.compareTo(maxValue) > 0) {
            throw new OpenDataException("minValue and/or maxValue is invalid: minValue is greater than maxValue");
        }
        if (defaultValue != null && minValue != null && minValue.compareTo((Comparable)defaultValue) > 0) {
            throw new OpenDataException("defaultvalue and/or minValue is invalid: minValue is greater than defaultValue");
        }
        if (defaultValue != null && maxValue != null && ((Comparable)defaultValue).compareTo(maxValue) > 0) {
            throw new OpenDataException("defaultvalue and/or maxValue is invalid: defaultValue is greater than maxValue");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public OpenType getOpenType() {
        return this.openType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Set getLegalValues() {
        return this.legalValues;
    }

    public Comparable getMinValue() {
        return this.minValue;
    }

    public Comparable getMaxValue() {
        return this.maxValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean hasLegalValues() {
        return this.legalValues != null;
    }

    public boolean hasMinValue() {
        return this.minValue != null;
    }

    public boolean hasMaxValue() {
        return this.maxValue != null;
    }

    public boolean isValue(Object obj) {
        return this.defaultValue != null ? this.openType.isValue(obj) : obj == null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenMBeanAttributeInfo)) {
            return false;
        }
        OpenMBeanAttributeInfo other = (OpenMBeanAttributeInfo)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getOpenType().equals(other.getOpenType())) {
            return false;
        }
        if (this.isReadable() != other.isReadable()) {
            return false;
        }
        if (this.isWritable() != other.isWritable()) {
            return false;
        }
        if (this.isIs() != other.isIs()) {
            return false;
        }
        if (this.hasDefaultValue() ? !this.getDefaultValue().equals(other.getDefaultValue()) : other.hasDefaultValue()) {
            return false;
        }
        if (this.hasMinValue() ? !this.minValue.equals(other.getMinValue()) : other.hasMinValue()) {
            return false;
        }
        if (this.hasMaxValue() ? !this.maxValue.equals(other.getMaxValue()) : other.hasMaxValue()) {
            return false;
        }
        return !(this.hasLegalValues() ? !((Object)this.legalValues).equals(other.getLegalValues()) : other.hasLegalValues());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.hashCode(this);
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.toStringName == null) {
            StringBuffer sb = new StringBuffer(this.getClass().getName());
            sb.append("(name=");
            sb.append(this.getName());
            sb.append(", opentype=");
            sb.append(this.openType.toString());
            sb.append(", defaultValue=");
            sb.append(this.hasDefaultValue() ? this.getDefaultValue().toString() : "null");
            sb.append(", minValue=");
            sb.append(this.hasMinValue() ? this.getMinValue().toString() : "null");
            sb.append(", maxValue=");
            sb.append(this.hasMaxValue() ? this.getMaxValue().toString() : "null");
            sb.append(", legalValues=");
            sb.append(this.hasLegalValues() ? this.getLegalValues().toString() : "null");
            sb.append(")");
            this.toStringName = sb.toString();
        }
        return this.toStringName;
    }

    private int hashCode(OpenMBeanAttributeInfoSupport info) {
        int result = info.getName().hashCode();
        result += info.getOpenType().hashCode();
        result += !info.hasDefaultValue() ? 0 : info.getDefaultValue().hashCode();
        result += !info.hasLegalValues() ? 0 : this.hashCode(info.getLegalValues());
        result += !info.hasMinValue() ? 0 : info.getMinValue().hashCode();
        return result += !info.hasMaxValue() ? 0 : info.getMaxValue().hashCode();
    }

    private int hashCode(Set legalvalues) {
        int result = 0;
        Iterator i = legalvalues.iterator();
        while (i.hasNext()) {
            Object v = i.next();
            result += v.hashCode();
        }
        return result;
    }
}

