// SetVarDialog.cpp : implementation file
//

#include "stdafx.h"
#include "SavApp.h"
#include "SetVarDialog.h"

#include "Model.h"
#include <vector>
#include ".\setvardialog.h"


// CSetVarDialog dialog

IMPLEMENT_DYNAMIC(CSetVarDialog, CDialog)
CSetVarDialog::CSetVarDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CSetVarDialog::IDD, pParent)
	, m_Variable1(_T(""))
	, m_Variable2(_T(""))
	, m_Variable3(_T(""))
	, m_Variable4(_T(""))
{
}

CSetVarDialog::CSetVarDialog(CModel* pModel, CWnd* pParent)
	:CDialog(CSetVarDialog::IDD, pParent)
{
	this->pModel = pModel;

	//
	// show already defined variables
	//
	CModel* model = this->pModel;
//	::ASSERT_VALID(model);

	vector<CString>& variables = model->getVariables();
	vector<CString>::iterator itr = variables.begin();
	int count=0;
	for (itr; itr!=variables.end(); itr++) {
		switch (count++) {
		case 0: m_Variable1 = *itr;	break;
		case 1: m_Variable2 = *itr;	break;
		case 2:	m_Variable3 = *itr;	break;
		case 3:	m_Variable4 = *itr;	break;
		default: break;
		}
	}

}

CSetVarDialog::~CSetVarDialog()
{
}

void CSetVarDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_VARIABLE1, m_Variable1);
	DDV_MaxChars(pDX, m_Variable1, 10);
	DDX_Text(pDX, IDC_EDIT_VARIABLE2, m_Variable2);
	DDV_MaxChars(pDX, m_Variable2, 10);
	DDX_Text(pDX, IDC_EDIT_VARIABLE3, m_Variable3);
	DDV_MaxChars(pDX, m_Variable3, 10);
	DDX_Text(pDX, IDC_EDIT_VARIABLE4, m_Variable4);
	DDV_MaxChars(pDX, m_Variable4, 10);
}


BEGIN_MESSAGE_MAP(CSetVarDialog, CDialog)
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
END_MESSAGE_MAP()


// CSetVarDialog message handlers

void CSetVarDialog::OnBnClickedOk()
{
	OnOK();

	//
	//     
	//
	pModel->clearVar();

	if (!m_Variable1.IsEmpty()) {
		pModel->createVar(m_Variable1);
	}
	if (!m_Variable2.IsEmpty()) {
		pModel->createVar(m_Variable2);
	}
	if (!m_Variable3.IsEmpty()) {
		pModel->createVar(m_Variable3);
	}
	if (!m_Variable4.IsEmpty()) {
		pModel->createVar(m_Variable4);
	}

}
