/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "knateoncommon.h"
#include "knateonview.h"
#include "util/common.h"
//Added by qt3to4:
#include <QLabel>
#include <QDesktopServices>

extern nmconfig stConfig;

bool KNateonInterface::initialize() {
    KStandardDirs *dirs = KGlobal::dirs();
	dirs->addResourceDir( "data", "/usr/share/apps" );
    QString sPicsPath = dirs->findResource( "data", QString( KGlobal::mainComponent().aboutData()->appName() ) + "/pics/" );

	setWindowIcon( QIcon( sPicsPath + "nateon.png") );

    /*! Status Bar */
    m_pStatusLabel = new QLabel(this);
    if (m_pStatusLabel) statusBar()->addWidget( m_pStatusLabel, 2 );
    /*!
      m_pStatusTimer = new QLabel(this);
      if (m_pStatusTimer)
      {
      m_pStatusTimer->setText("00:00");
      statusBar()->addWidget(m_pStatusTimer, 0, true);
      }

      m_pStatusProgress = new KLed(this);
      if (m_pStatusProgress)
      {
      m_pStatusProgress->setMaximumHeight(16);
      statusBar()->addWidget(m_pStatusProgress, 0, true);
      }
    */
    createActions();
    // Create the menus
    createMenus();
    OfflineEnableMenu();
    /// 오른쪽 마우스 메뉴 만들기.
    // initContactPopup();
    // connect( contactListView_, SIGNAL( contextMenuRequested(QListViewItem*,const QPoint&,int) ), this, SLOT( slotContextMenu(QListViewItem*,const QPoint&,int) ) );
    // load window size & position
	KConfigGroup config = KGlobal::config()->group( "default" );
    readProperties( config );
	
    KStandardAction::close( this, SLOT( slotAppClose() ), this );
    KStandardAction::quit( this, SLOT( slotAppClose() ), this );

    return true;
}


/*!
  \fn knateon::createMenus()
*/
void KNateonInterface::createMenus() {
    createFileMenu();
    createActionsMenu();
    createFriendMenu();
    createSetupMenu();
    createHelpMenu();
}

/*
  {

  KAction *close, *quit;
  KMenu *connectMenu;
  QStringList statuses;

  Create the menu
  connectMenu  = new KMenu( this, "connectmenu" );

  Create the "connect" menu items

  m_pConnectActionMenu    = new KActionMenu( i18n("login"), "connect_creating", this, "connect");
  m_pDisconnect           = new KAction( i18n("logout"), "connect_no", 0, this, SLOT( disconnectClicked() ), actionCollection(), "disconnect");
  m_pShowProfile          = new KAction( i18n("View My Profile"), "kmess", 0, this, SLOT( showUserProfile() ), actionCollection(), "showuserprofile");
  m_pStatus               = new KSelectAction( i18n("My Status"), "misc", 0, this, "status");
  statuses << i18n("Online") << i18n("Away") << i18n("Busy") << i18n("On the phone") << i18n("on meeting") << i18n("Offline");
  m_pStatus->setItems(statuses);

  connect ( m_pStatus, SIGNAL( activated( const QString& ) ), this, SLOT( changeStatus( const QString& ) ) );
  close = KStandardAction::close( this, SLOT( menuClose() ), actionCollection() );
  quit = KStandardAction::quit( this, SLOT( menuQuit() ), actionCollection() );

  m_pConnectActionMenu->plug( connectMenu );
  m_pDisconnect->plug( connectMenu );
  connectMenu->insertSeparator( );
  m_pStatus->plug( connectMenu );
  m_pShowProfile->plug( connectMenu );
  connectMenu->insertSeparator();
  close->plug( connectMenu );
  quit->plug( connectMenu );

  // Plug the menu into the menubar
  menuBar()->insertItem( i18n("file(&F)"), connectMenu);

  m_pDisconnect->plug( toolBar("mainToolBar") );
  m_pStatus->plug( toolBar("mainToolBar") );
  close->plug( toolBar("mainToolBar") );
  quit->plug( toolBar("mainToolBar") );
  toolBar("mainToolBar")->show();
  }
*/

/*!
  \fn knateon::createConnectMenu()
*/
void KNateonInterface::createFileMenu() {
    // file menu
    pLogoutAction = new KAction( i18n("로그아웃(&N)"), this );
    pOpenchatboxAction = new KAction( i18n("대화함 열기(&H)"), this );
    pOpenfileboxAction = new KAction( i18n("받은 파일 폴더 열기(&R)"), this );
	connect( pOpenfileboxAction, SIGNAL( triggered() ), 
			this, SLOT( slotOpenFileBox() ) );

    pOpendownboxAction = new KAction( i18n("파일전송창 열기(&T)"), this );
    pHideAction = new KAction( i18n("숨기기(&C)"), this );
	pHideAction->setShortcut( Qt::Key_Escape);
	connect( pHideAction, SIGNAL( triggered() ), 
			this, SLOT( slotMenuHide() ) );

    pQuitAction = new KAction( i18n("종료(&X)"), this );
	pQuitAction->setShortcut( Qt::CTRL + Qt::Key_Q );

    KMenu *pFile = new KMenu( this );
	KActionCollection *ac = actionCollection();
	pFile->addAction( ac->addAction("logout_action", pLogoutAction ) );
    pFile->insertSeparator();

	pFile->addAction( ac->addAction("open_chatbox_action", pOpenchatboxAction ) );
	pFile->addAction( ac->addAction("open_filebox_action", pOpenfileboxAction ) );
	pFile->addAction( ac->addAction("open_downbox_action", pOpendownboxAction ) );
    pFile->insertSeparator();

	pFile->addAction( ac->addAction("hide_action", pHideAction ) );
	pFile->addAction( ac->addAction("quit_action", pQuitAction ) );
    // menuBar()->insertItem( i18n("&FILE"), pFile);
    menuBar()->insertItem( ki18n("파일(&F)").toString(), pFile);
}
/*!

 */
void KNateonInterface::createActionsMenu() {
    // action menu
    pChatAction = new KAction( i18n("대화하기(&G)"), this );
	pChatAction->setShortcut( Qt::CTRL + Qt::Key_G );

    pSendmemoAction = new KAction( i18n("쪽지 보내기(&N)"), this );
	pSendmemoAction->setShortcut( Qt::CTRL + Qt::Key_B );

    pSendfileAction = new KAction( i18n("파일 보내기(&F)"), this );
	pSendfileAction->setShortcut( Qt::CTRL+Qt::Key_T );

    KMenu *pAction = new KMenu( this );
	KActionCollection *ac = actionCollection();
	pAction->addAction( ac->addAction("chat_action", pChatAction ) );
    pAction->insertSeparator();

	pAction->addAction( ac->addAction("send_memo_action", pSendmemoAction ) );
	pAction->addAction( ac->addAction("send_file_action", pSendfileAction ) );
    menuBar()->insertItem( i18n("동작(&M)"), pAction);
}

/*!

 */
void KNateonInterface::createFriendMenu() {
    /*
    // friend menu
    pAddfriendAction        = new KAction(i18n("Add a buddy"), "1", 0, this, "add_friend_menu");
    pCopyfriendSelectAction = new KSelectAction( i18n("Copy a buddy"), "/home/x/devel/knateon/src/pics/kmess/offline.png", 0, this, "copy");
    pMovefriendSelectAction = new KSelectAction( i18n("Move a buddy"), "misc", 0, this, "move");
    // pMovefriendSelectAction ->setItems(m_Group);
    // pMovefriendSelectAction->setEditable(false);
    pDeletefriendAction     = new KAction(i18n("Delete a buddy"), "1", 0, this, SLOT( empty() ), actionCollection(), "11");

    pBuddynamingSelectAction= new KSelectAction( i18n("Buddy's screen name setting"), "friend", 0, this, "naming");
    QStringList m_naming;
    m_naming << i18n("View buddies by name") << i18n("View buddies by screen name") << i18n("View buddies by name and ID") << i18n("View buddies by name and screen name");
    pBuddynamingSelectAction->setItems(m_naming);
    pBuddynamingSelectAction->setCurrentItem(0);

    pSortlistSelectAction   = new KSelectAction( i18n("Buddy viewing option"), "friend", 0, this, "sorting");
    QStringList m_sorting;
    m_sorting << i18n("View &All") << i18n("View &Connected Only") << i18n("View On/Off");
    pSortlistSelectAction->setItems(m_sorting);
    pSortlistSelectAction->setCurrentItem(0);

    pAddgroupAction         = new KAction(i18n("Add Group"), "1", 0, this, "add_group_menu");
    pRenamegroupAction      = new KAction(i18n("Rename Group"), "1", 0, this, "rename_group_menu");
    pDeletegroupAction      = new KAction(i18n("Delete Group"), "1", 0, this, "delete_group_menu");
    */
    // friend menu
    pAddfriendAction = new KAction( i18n("친구 추가(&A)"), this );
    pCopyfriendSelectAction = new KSelectAction( i18n("친구 복사(&C)"), this );
    pMovefriendSelectAction = new KSelectAction( i18n("친구 이동(&O)"), this );
    pDeletefriendAction = new KAction( i18n("친구 삭제(&D)"), this );
	pDeletefriendAction->setShortcut( Qt::Key_Delete );

    pLoadBuddyListAction = new KAction( i18n("친구 목록 불러오기(&L)"), this );
    pSaveBuddyListAction = new KAction( i18n("친구 목록 저장하기(&P)"), this );

    pBuddynamingSelectAction= new KSelectAction( i18n("친구 보기 방식(&U)"), this );
    QStringList m_naming;
    m_naming << i18n("친구 이름으로 보기(&R)") 
			 << i18n("친구 대화명으로 보기(&N)") 
			 << i18n("친구 이름+아이디로 보기(&M)") 
			 << i18n("친구 이름+대화명으로 보기(&E)");
    pBuddynamingSelectAction->setItems(m_naming);
    pBuddynamingSelectAction->setCurrentItem(3);

    pSortlistSelectAction = new KSelectAction( i18n("친구 정렬 방식(&Y)"), this );
    QStringList m_sorting;
    m_sorting << i18n("친구 전체 보기(&A)") 
			  << i18n("접속한 친구만 보기(&O)") 
			  << i18n("친구 온라인/오프라인으로 보기(&D)");
    pSortlistSelectAction->setItems(m_sorting);
    pSortlistSelectAction->setCurrentItem(0);

    pAddgroupAction = new KAction( i18n("그룹 추가(&N)"), this );
    pRenamegroupAction = new KAction( i18n("그룹 이름 변경(&N)"), this );
    pDeletegroupAction = new KAction( i18n("그룹 삭제(&D)"), this ); 

    KMenu *pFriend = new KMenu( this );
	KActionCollection *ac = actionCollection();
	pFriend->addAction( ac->addAction("add_friend_action", pAddfriendAction ) );
	pFriend->addAction( ac->addAction("copy_friend_select_action", pCopyfriendSelectAction ) );
	pFriend->addAction( ac->addAction("move_friend_select_action", pMovefriendSelectAction ) );
	pFriend->addAction( ac->addAction("delete_friend_action", pDeletefriendAction ) );

    pFriend->insertSeparator();
	pFriend->addAction( ac->addAction("load_buddy_list_action", pLoadBuddyListAction ) );
	pFriend->addAction( ac->addAction("save_buddy_list_action", pSaveBuddyListAction ) );

    pFriend->insertSeparator();
	pFriend->addAction( ac->addAction("buddy_naming_select_action", pBuddynamingSelectAction ) );
	pFriend->addAction( ac->addAction("sortlist_select_action", pSortlistSelectAction ) );

    pFriend->insertSeparator();
	pFriend->addAction( ac->addAction("add_group_action", pAddgroupAction ) );
	pFriend->addAction( ac->addAction("rename_group_action", pRenamegroupAction ) );
	pFriend->addAction( ac->addAction("delete_group_action", pDeletegroupAction ) );
    // menuBar()->insertItem( i18n("BUDDY"), pFriend);
    menuBar()->insertItem( i18n("친구(&R)"), pFriend);
}



void KNateonInterface::createSetupMenu() {
    QStringList statuses;
    // setup menu
    pChangestatusSelectAction = new KSelectAction( i18n("내 상태 설정(&U)"), this );
    statuses << i18n("온라인") 
			 << i18n("자리비움") 
			 << i18n("다른 용무중") 
			 << i18n("통화 중") 
			 << i18n("회의 중") 
			 << i18n("오프라인 표시");
    pChangestatusSelectAction->setItems(statuses);
    pChangestatusSelectAction->setCurrentItem(0);
    connect( pChangestatusSelectAction, SIGNAL( triggered( int ) ), 
			this, SLOT( slotChangeStatusNumber( int ) ) );

    pChangenickAction = new KAction( i18n("내 대화명 설정(&P)"), this );
    pAlwaystopAction = new KToggleAction( i18n("항상 위(&N)"), this );
    pSetupAction = new KAction( i18n("환경 설정(&S)"), this );
    pNetLogAction = new KAction( i18n("프로토콜 로그 보기(&L)"), this );

    KMenu *pSetup = new KMenu( this );
	KActionCollection *ac = actionCollection();
	pSetup->addAction( ac->addAction("change_status_select_action", pChangestatusSelectAction ) );
	pSetup->addAction( ac->addAction("change_nick_action", pChangenickAction ) );

    pSetup->insertSeparator();
	pSetup->addAction( ac->addAction("alway_stop_action", pAlwaystopAction ) );
	pSetup->addAction( ac->addAction("setup_action", pSetupAction ) );

    pSetup->insertSeparator();
	pSetup->addAction( ac->addAction("netlog_action", pNetLogAction ) );
    menuBar()->insertItem( i18n("설정(&S)"), pSetup);

    bool bNetLog = false;
#ifdef DEBUG
    bNetLog = true;
#endif
    pNetLogAction->setEnabled(bNetLog);
}

/*!

 */
void KNateonInterface::createHelpMenu() {
    /*
    // help menu
    pGonateonhomeAction     = new KAction(i18n("NateOn homepage"), "1", 0, this, SLOT( empty() ), actionCollection(), "11");
    pGocyworldhomeAction    = new KAction(i18n("Cyworld homepage"), "1", 0, this, SLOT( empty() ), actionCollection(), "11");
    pGonatedotcomAction     = new KAction(i18n("Nate.com"), "1", 0, this, SLOT( empty() ), actionCollection(), "11");
    pGonateonhelpAction     = new KAction(i18n("NateOn user guide"), "1", 0, this, SLOT( empty() ), actionCollection(), "11");
    pGonateonminihompyAction= new KAction(i18n("NateOn mini homepage"), "1", 0, this, SLOT( empty() ), actionCollection(), "11");
    pGonateonfaqAction      = new KAction(i18n("NateOn FAQ"), "1", 0, this, SLOT( empty() ), actionCollection(), "11");
    pGonateoninfo           = new KAction(i18n("NateOn infomation"), "1", 0, this, SLOT( empty() ), actionCollection(), "11");
    */
    // help menu
    pGonateonhomeAction = new KAction( i18n("네이트온 홈(&O)"), this );
	connect( pGonateonhomeAction, SIGNAL( triggered() ),
			this, SLOT( slotGoNateHome() ) );
    pGocyworldhomeAction = new KAction( i18n("싸이월드 홈(&C)"), this );
	connect( pGocyworldhomeAction, SIGNAL( triggered() ),
			this, SLOT( slotGoCyHome() ) );
    pGonatedotcomAction = new KAction( i18n("네이트 홈(&N)"), this );
	connect( pGonatedotcomAction, SIGNAL( triggered() ), 
			this, SLOT( slotGoNateDotCom() ) );
    pGonateonhelpAction = new KAction( i18n("네이트온 이용 가이드(&G)"), this );
	pGonateonhelpAction->setShortcut( Qt::Key_F1 );
	connect( pGonateonhelpAction, SIGNAL( triggered() ), 
			this, SLOT( slotNateonUsage() ) );

    pGonateonminihompyAction = new KAction( i18n("네이트온 미니 홈피(&M)"), this );
	connect( pGonateonminihompyAction, SIGNAL( triggered() ),
			this, SLOT( slotGoNateonMiniHompy() ) );

    pGonateonfaqAction = new KAction( i18n("네이트온 FAQ(&F)"), this );
	connect( pGonateonfaqAction, SIGNAL( triggered() ), 
			this, SLOT( slotFAQ() ) );

    helpMenu_ = new KHelpMenu(this, KGlobal::mainComponent().aboutData(), false, actionCollection());
    pGonateoninfo = KStandardAction::aboutApp(helpMenu_, SLOT( aboutApplication()/*slotInfo()*/ ), actionCollection() );

    KMenu *pHelp = new KMenu( this );
	KActionCollection *ac = actionCollection();
	pHelp->addAction( ac->addAction("go_nateon_home_action", pGonateonhomeAction ) );
	pHelp->addAction( ac->addAction("go_cyworld_home_action", pGocyworldhomeAction ) );	
	pHelp->addAction( ac->addAction("go_natedotcom_action", pGonatedotcomAction ) );	

    pHelp->insertSeparator();
	pHelp->addAction( ac->addAction("go_nateon_help_action", pGonateonhelpAction ) );	
	pHelp->addAction( ac->addAction("go_nateon_minihompy_action", pGonateonminihompyAction ) ) ;	
	pHelp->addAction( ac->addAction("go_nateon_faq_action", pGonateonfaqAction ) );	

    pHelp->insertSeparator();
	pHelp->addAction( ac->addAction("go_nateon_info", pGonateoninfo ) );	
    // menuBar()->insertItem( i18n("HELP"), pHelp);
    menuBar()->insertItem( i18n("도움말(&H)"), pHelp);
}


/*!
  \fn knateon::readProperty(const KConfigGroup &cg)
*/
void KNateonInterface::readProperties( const KConfigGroup & cg ) {
	Q_UNUSED( cg );

    // Pull in the window size and position
	KConfigGroup config = KGlobal::config()->group( "General" );
    QSize windowsize = config.readEntry("Size", QSize(200, 400));
    if (!windowsize.isEmpty()) {
        resize(windowsize);
    }
    QPoint position = config.readEntry("Position", QPoint(0, 0));
    if (!position.isNull()) {
        move(position);
    }

    /*
    // bar status settings
    bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
    showToolBar_->setChecked(bViewToolbar);
    showToolBar();

    bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
    showStatusBar_->setChecked(bViewStatusbar);
    showStatusBar();
    */
    // bar position settings
    /// XXXXXXXXXXXXXXXXXXXXx

    /*
      KToolBar::BarPosition toolBarPos;
      toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);
      toolBar("mainToolBar")->setBarPos(toolBarPos);
    */
}


/*!
  \fn knateon::saveProperty(KConfigGroup &cg)
*/
void KNateonInterface::saveProperties( KConfigGroup &cg ) {
	Q_UNUSED( cg );

	KConfigGroup config = KGlobal::config()->group( "General" );
    config.writeEntry("Size", size() );
    config.writeEntry("Position", pos() );
    //	config->writeEntry("Show Toolbar", showToolBar_->isChecked() );
    //	config->writeEntry("Show Statusbar", showStatusBar_->isChecked() );
    //  config->writeEntry("ToolBarPos", (int) toolBar("mainToolBar")->barPos() );
}


/*!
  \fn knateon::menuQuit()
*/
void KNateonInterface::menuQuit() {
    //	KMessageBox::information( this, "oops, KNateonInterface initialize fail!", "caption", 0, 0);
    KApplication *app = static_cast<KApplication *>(kapp);
    app->quit();
    //app->setQuitSelected(true);

    close();                     // Close this window, initiates quit
}


#include "knateonview.moc"

/*!
  \fn KNateonInterface::initContactPopup()
*/
bool KNateonInterface::initContactPopup() {
    /*
      chatWithContact_   = new KAction(i18n("Cha&t"),             "launch",       0, this, "chat");

      connect( chatWithContact_,   SIGNAL(activated()),   this,  SLOT(slotForwardStartChat())      );

      moveContactToGroup_ = new KActionMenu(i18n("&Move to Group"), 0, 0, "moveToGroup");

      // Initialize the popup menu
      contactActionPopup_ = new KMenu(this);
      contactActionPopup_->insertTitle("KNateon", 0);

      chatWithContact_   ->plug(contactActionPopup_);
    */
    return true;
}



/*!
  \fn KNateonInterface::slotRightClickMenu()
*/
void KNateonInterface::slotRightClickMenu(Q3ListViewItem *item, const QPoint &point, int /*col*/) {
    // Not name, because most msn names are too weird.
    /*
      contactActionPopup_->changeTitle(0, "ring0320@nate.com");
      contactActionPopup_->popup(point);
    */
    Q_UNUSED( item );
    Q_UNUSED( point );
}

/*!
  액션 설정
*/
void KNateonInterface::createActions() {
}

void KNateonInterface::slotSetGroupList(QStringList & Group) {
    // m_Group = Group;
    pCopyfriendSelectAction ->setItems(Group);
    pMovefriendSelectAction ->setItems(Group);
}

// #include "dialog/emoticonselector.h"
#include "dialog/filetransfer.h"
FileTransfer* MyDialog;

void KNateonInterface::slotOpenChatBox() {
    /*
      EmoticonSelector *MyDialog = new EmoticonSelector(this, "xx");
      MyDialog->setModal(true);
      MyDialog->exec();
    */
    if (!MyDialog) {
        MyDialog = new FileTransfer(this, "xx");
        MyDialog->setModal(true);
        MyDialog->exec();
    }
    MyDialog->hidelist();
    MyDialog->show();
}

// #include "dialog/webviewer.h"
// #include <kparts/browserextension.h>
#include <kglobal.h>
void KNateonInterface::slotOpenFileBox() {
    if ( stConfig.filedownloadpath != QString::null ) {
		QDesktopServices::openUrl( 
				QUrl::fromLocalFile( stConfig.filedownloadpath ) );
	}
    else {
		QDesktopServices::openUrl( 
				QUrl::fromLocalFile( QDir::homePath() ));
	}
}

void KNateonInterface::slotSendMemo() {
    emit viewMemoWindow();
}

void KNateonInterface::slotGoNateHome() {
    LNMUtils::openURL("http://nateonweb.nate.com");
}

void KNateonInterface::slotGoCyHome() {
    LNMUtils::openURL( "http://cyworld.nate.com" );
}

void KNateonInterface::slotGoNateDotCom() {
    LNMUtils::openURL( "http://www.nate.com" );
}

void KNateonInterface::slotNateonUsage() {
    QString sURL("http://br.nate.com/index.php");
    sURL += "?code=E069";
    LNMUtils::openURL( sURL );
}

void KNateonInterface::slotGoNateonMiniHompy() {
    LNMUtils::openURL( "http://cyworld.nate.com/nateoncyevent" );
}

void KNateonInterface::slotFAQ() {
    QString sURL("http://br.nate.com/index.php");
    sURL += "?code=E009";
    LNMUtils::openURL( sURL );
}

// extern KAboutData aboutData;

void KNateonInterface::slotInfo() {
    if ( !helpMenu_ )
        helpMenu_= new KHelpMenu(this, KGlobal::mainComponent().aboutData());
    helpMenu_->aboutApplication();
}

void KNateonInterface::OfflineEnableMenu() {
    pLogoutAction->setEnabled( false );
    pOpenchatboxAction->setEnabled( false );
    pChatAction->setEnabled( false );
    pSendmemoAction->setEnabled( false );
    pSendfileAction->setEnabled( false );
    pAddfriendAction->setEnabled( false );
    pCopyfriendSelectAction->setEnabled( false );
    pMovefriendSelectAction->setEnabled( false );
    pDeletefriendAction->setEnabled( false );
    pBuddynamingSelectAction->setEnabled( false );
    pSortlistSelectAction->setEnabled( false );
    pAddgroupAction->setEnabled( false );
    pRenamegroupAction->setEnabled( false );
    pDeletegroupAction->setEnabled( false );
    pChangestatusSelectAction->setEnabled( false );
    pChangenickAction->setEnabled( false );

    pLoadBuddyListAction->setEnabled( true );
    pSaveBuddyListAction->setEnabled( true );

    /*! TODO : Disable 다시 수정 필요 */
    pSetupAction->setEnabled( true );
#ifdef DEBUG
    pNetLogAction->setEnabled( true );
#endif
}

void KNateonInterface::OnlineEnableMenu() {
    pLogoutAction->setEnabled( true );
    pOpenchatboxAction->setEnabled( true );
    pChatAction->setEnabled( true );
    pSendmemoAction->setEnabled( true );
    pSendfileAction->setEnabled( true );
    pAddfriendAction->setEnabled( true );
    pCopyfriendSelectAction->setEnabled( true );
    pMovefriendSelectAction->setEnabled( true );
    pDeletefriendAction->setEnabled( true );
    pBuddynamingSelectAction->setEnabled( true );
    pSortlistSelectAction->setEnabled( true );
    pAddgroupAction->setEnabled( true );
    pRenamegroupAction->setEnabled( true );
    pDeletegroupAction->setEnabled( true );
    pChangestatusSelectAction->setEnabled( true );
    pChangenickAction->setEnabled( true );
    pSetupAction->setEnabled( true );
#ifdef DEBBUG
    pNetLogAction->setEnabled( true );
#endif

    pLoadBuddyListAction->setEnabled( true );
    pSaveBuddyListAction->setEnabled( true );
}

void KNateonInterface::slotAppClose() {
    hide();
}

void KNateonInterface::slotMenuHide() {
    hide();
}

void KNateonInterface::slotChangeStatusNumber(int nID) {
    Q_UNUSED( nID );
}
