/****************************************************************************
** Form implementation generated from reading ui file 'loginmanagerview.ui'
**
** Created: 월  5월 3 23:53:09 2010
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/

#include "loginmanagerview.h"

#include <qobject.h>
#include <qvariant.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qframe.h>
#include <q3textedit.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <q3buttongroup.h>
#include <qtooltip.h>
#include <q3whatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
//Added by qt3to4:
#include <QHBoxLayout>
#include <QVBoxLayout>
#include "../knateoncommon.h"
#include "util/common.h"
#include <kmessagebox.h>
#include <kapplication.h>
#include <stdlib.h>
#include <q3hbox.h>
#include <kglobal.h>
#include <kdebug.h>

extern nmconfig stConfig;

typedef enum {
    MediaTypeNone = 0,
    MediaTypePC,       // 1 , PC
    MediaTypeSKVM,     // 2
    MediaTypeMobile01, // 3
    MediaTypeMobile02, // 4
    MediaTypeMac,      // 5 , PC
    MediaTypeLinux,    // 6 , PC
    MediaTypeiPod,     // 7
    MediaTypeEmpty01,  // 8
    MediaTypeWM,       // 9
    MediaTypeAndroid   // 10
} MediaType;

/*
 *  Constructs a LoginManager as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
LoginManager::LoginManager( QWidget* parent, const char* name, bool modal, Qt::WFlags fl )
    : QDialog( parent, name, modal, fl )
{
	config = KGlobal::config()->group( "LoginManager Options" );

	KStandardDirs *dirs = KGlobal::dirs();
	dirs->addResourceDir( "data", "/usr/share/apps" );
	sPicsPath = dirs->findResource( "data", 
	QString( KGlobal::mainComponent().aboutData()->appName() ) + "/pics/" );

    if ( !name )
		setName( "LoginManager" );
    LoginManagerLayout = new QHBoxLayout( this, 11, 6, "LoginManagerLayout"); 
	emptyBox = NULL; 
    layout14 = new QVBoxLayout( 0, 0, 6, "layout14"); 

    topTextLabel = new QLabel( this, "topTextLabel" );
    topTextLabel->setAlignment( int( Qt::TextWordWrap | Qt::AlignVCenter ) );
    layout14->addWidget( topTextLabel );

    line1 = new QFrame( this, "line1" );
    line1->setFrameShape( QFrame::HLine );
    line1->setFrameShadow( QFrame::Sunken );
    line1->setFrameShape( QFrame::HLine );
    layout14->addWidget( line1 );

    layout11 = new QHBoxLayout( 0, 0, 6, "layout11"); 

    layout9 = new QVBoxLayout( 0, 0, 6, "layout9"); 

    curTextLabel = new QLabel( this, "curTextLabel" );
    layout9->addWidget( curTextLabel );

    layout7 = new QHBoxLayout( 0, 0, 6, "layout7"); 

    curPixmapLabel = new QLabel( this, "curPixmapLabel" );
    curPixmapLabel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, curPixmapLabel->sizePolicy().hasHeightForWidth() ) );
    curPixmapLabel->setMaximumSize( QSize( 20, 20 ) );
    curPixmapLabel->setPixmap(  QPixmap ( sPicsPath + "icon_computer.png") );
    curPixmapLabel->setScaledContents( FALSE );
    layout7->addWidget( curPixmapLabel );

    curInfotextLabel = new QLabel( this, "curInfotextLabel" );
    layout7->addWidget( curInfotextLabel );
    layout9->addLayout( layout7 );
    spacer4 = new QSpacerItem( 31, 51, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout9->addItem( spacer4 );
    layout11->addLayout( layout9 );

    layout5 = new QVBoxLayout( 0, 0, 6, "layout5"); 

    layout4 = new QHBoxLayout( 0, 0, 6, "layout4"); 

    plusPixmapLabel = new QLabel( this, "plusPixmapLabel" );
    plusPixmapLabel->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, plusPixmapLabel->sizePolicy().hasHeightForWidth() ) );
    plusPixmapLabel->setMaximumSize( QSize( 14, 14 ) );
    plusPixmapLabel->setPixmap(  QPixmap ( sPicsPath + "icon_plus.png") );
    plusPixmapLabel->setScaledContents( FALSE );
    layout4->addWidget( plusPixmapLabel );

    otherTextLabel = new QLabel( this, "otherTextLabel" );
    layout4->addWidget( otherTextLabel );

    allLogoutPushButton = new QPushButton( this, "allLogoutPushButton" );
    allLogoutPushButton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, allLogoutPushButton->sizePolicy().hasHeightForWidth() ) );
    allLogoutPushButton->setMaximumSize( QSize( 71, 18 ) );
    allLogoutPushButton->setPixmap( QPixmap ( sPicsPath + "btn_logoutall.png"));
    allLogoutPushButton->setFlat( TRUE );
    layout4->addWidget( allLogoutPushButton );
    layout5->addLayout( layout4 );
    connect( allLogoutPushButton, SIGNAL( clicked() ), this, SLOT( allLogoutClicked() ) );

    spacer5 = new QSpacerItem( 31, 51, QSizePolicy::Minimum, QSizePolicy::Expanding );
	layout5->addItem( spacer5 );
	layout11->addLayout( layout5 );
	layout14->addLayout( layout11 );

    layout12 = new QHBoxLayout( 0, 0, 6, "layout12"); 

    statusTextLabel = new QLabel( this, "statusTextLabel" );
    layout12->addWidget( statusTextLabel );

    statusComboBox = new QComboBox( FALSE, this, "statusComboBox" );
    layout12->addWidget( statusComboBox );
    layout14->addLayout( layout12 );

	line2 = new QFrame( this, "line2" );
    line2->setFrameShape( QFrame::HLine );
    line2->setFrameShadow( QFrame::Sunken );
    line2->setFrameShape( QFrame::HLine );
    layout14->addWidget( line2 );

    layout13 = new QHBoxLayout( 0, 0, 6, "layout13"); 

    loginViewCheckBox = new QCheckBox( this, "loginViewCheckBox" );
    layout13->addWidget( loginViewCheckBox );

    okPushButton = new QPushButton( this, "okPushButton" );
    layout13->addWidget( okPushButton );
    layout14->addLayout( layout13 );
    LoginManagerLayout->addLayout( layout14 );
    languageChange();
    resize( QSize(514, 395).expandedTo(minimumSizeHint()) );

	loginViewCheckBox->setChecked( config.readEntry( "ShowLoginManager", false) );
	statusComboBox->setCurrentItem( config.readEntry( "LogoutStatus", 0 ));
    // signals and slots connections
    connect( okPushButton, SIGNAL( clicked() ), this, SLOT( okClicked() ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
LoginManager::~LoginManager()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void LoginManager::languageChange()
{
    setCaption( UTF8("로그인 매니저") );
    topTextLabel->setText( UTF8("로그인 된 장치의 리스트입니다. 다른 장치에 로그인이 된 경우 일부 대화,\n쪽지 내용이 다른 장치에 표시 될 수 있습니다. 사용하지 않는 장치는 로그아웃해 주세요.") );
    curTextLabel->setText( UTF8("<b>현재 네이트온 위치</b>") );
	curInfotextLabel->setText( UTF8("컴퓨터 - ") + stConfig.pcname.utf8() );
    otherTextLabel->setText( UTF8("<b>다른 네이트온 위치</b>") );
    allLogoutPushButton->setText( QString::null );

	updateSessionList();
    statusTextLabel->setText( UTF8("현재 장치 로그아웃할 때 다른 장치의 상태정보 변경") );
    statusComboBox->clear();
    statusComboBox->insertItem( UTF8("변경하지 않음") );
    statusComboBox->insertItem( UTF8("온라인") );
    statusComboBox->insertItem( UTF8("자리 비움") );
    statusComboBox->insertItem( UTF8("다른 용무중") );
    statusComboBox->insertItem( UTF8("통화중") );
    statusComboBox->insertItem( UTF8("회의중") );
    statusComboBox->insertItem( UTF8("오프라인 표시") );
    loginViewCheckBox->setText( UTF8("로그인시 여러 장치에서 접속한 경우 로그인 매니저 보이기") );
    okPushButton->setText( UTF8("확인") );
}

void LoginManager::updateSessionList() {
	/* 이전 항목 삭제 */
	if (listBoxes.count() > 0) {
		Q3HBox *lst;
		for (lst = listBoxes.first(); lst; 
			lst = listBoxes.next()) {
			lst->hide();
		}
		listBoxes.clear();
	}

	if ( emptyBox ) {
		QLabel *label = emptyBox->findChild<QLabel *>("otherLocText");
		if (label) {
			label->setText("");
		}
		layout5->removeWidget( emptyBox );	
		emptyBox = NULL;
	}

	if (stConfig.sessioncount == 1) {
		emptyBox = new Q3HBox( this );
		QLabel *otherLocText = new QLabel( emptyBox, "otherLocText" );
		otherLocText->setText( UTF8( "로그인된 다른 장치가 없습니다." ) );
	
		layout5->removeItem( spacer5 );
		layout5->addWidget( emptyBox );	
		layout5->addItem( spacer5 );
		allLogoutPushButton->hide();
		emptyBox->show();
		return;
	}

	int i = 0;
	sessioninfo *s;
	for (s = stConfig.sessionlist.first(); s; 
		s = stConfig.sessionlist.next()) {
		if (s->dpkey.right(4) == stConfig.lockey) {
			i++;
			continue;
		}

		QString slMediaTypeIcon;
		QString slMediaTypeLabel;
		
		switch (s->mediatype) {
		case MediaTypePC:
		case MediaTypeMac:
		case MediaTypeLinux:
			slMediaTypeIcon = "icon_computer.png";
			slMediaTypeLabel = i18n( "컴퓨터" );
			break;
		case MediaTypeSKVM:
		case MediaTypeMobile01:
		case MediaTypeMobile02:
		case MediaTypeiPod:
		case MediaTypeEmpty01:
		case MediaTypeWM:
		case MediaTypeAndroid:
			slMediaTypeIcon = "icon_mobile.png";
			slMediaTypeLabel = i18n( "모바일" );
			break;
		default:
			slMediaTypeIcon = "icon_web.png";
			slMediaTypeLabel = i18n( "웹" );
			break;
		}

		Q3HBox *listBox = new Q3HBox(this);
		QLabel *otherLocType = new QLabel( listBox, "otherLocType" );
		otherLocType->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, 
					(QSizePolicy::SizeType)0, 0, 0, 
					otherLocType->sizePolicy().hasHeightForWidth() ) );
		otherLocType->setMaximumSize( QSize( 20, 20 ) );
		otherLocType->setPixmap( QPixmap ( sPicsPath + slMediaTypeIcon ) ); 
		otherLocType->setScaledContents( FALSE );

		QLabel *otherLocText = new QLabel( listBox, "otherLocText" );
		otherLocText->setText (" " + slMediaTypeLabel + " - " + s->displayname);

		QString senderName = QString::number(i++);
		QPushButton *logoutButton = new QPushButton( listBox, senderName.toAscii() );
		logoutButton->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, allLogoutPushButton->sizePolicy().hasHeightForWidth() ) );
		logoutButton->setMaximumSize( QSize( 51, 18 ) );
		logoutButton->setPixmap( QPixmap ( sPicsPath + "btn_logout.png") );
		logoutButton->setFlat( TRUE );
		connect( logoutButton, SIGNAL( clicked() ), this, SLOT( logoutClicked() ) );

		layout5->removeItem( spacer5 );
		layout5->addWidget( listBox );
		layout5->addItem( spacer5 );
		listBox->show();
		listBoxes.append( listBox );
	} 
	allLogoutPushButton->show();
}

void LoginManager::allLogoutClicked() {
	int result = KMessageBox::questionYesNo( this, 
						UTF8("다른 모든 장치를 로그아웃시키겠습니까?"));
	
	if ( result == KMessageBox::No ) {
		return;	
	}	
	
	emit allLogout( this );
	
	KMessageBox::information( this, 
			UTF8("다른 모든 장치를 로그아웃시켰습니다."), UTF8("알림"));
}

void LoginManager::logoutClicked() {
	
	int senderId = atoi( sender()->name()) ;
	sessioninfo *s = (sessioninfo *)stConfig.sessionlist.at(senderId);

	int result = KMessageBox::questionYesNo( this,
						"'" + s->displayname.utf8() + "'" + 
						i18n( " 네이트온을 로그아웃 시키시겠습니까?"));
	if ( result == KMessageBox::No ) {
		return;
	}

	emit otherLocLogout( s->dpkey );

	KMessageBox::information( this, 
					    "'" + s->displayname + "'" + 
					    i18n( " 네이트온을 로그아웃시켰습니다."), 
					    i18n("알림"));
	updateSessionList();
}

void LoginManager::okClicked() {
	/* 설정 저장 */
	config = KGlobal::config()->group( "LoginManager Options" );
	config.writeEntry( "LogoutStatus", statusComboBox->currentItem() );
	config.writeEntry( "ShowLoginManager", loginViewCheckBox->isChecked() );
	config.sync();
  
	close();
}

#include "loginmanagerview.moc"
