/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef FILETRANSFER_H
#define FILETRANSFER_H

#include <q3groupbox.h>
#include <qlayout.h>
#include <q3listview.h>
#include <qprogressbar.h>
#include <qlabel.h>

#include <kmessagebox.h>
#include <kdebug.h>
#include "filetransferinterface.h"

class SendFileInfo;

/**
   @author Doo-Hyun Jang <ring0320@nate.com>
*/
class FileTransfer : public FileTransferForm {
    Q_OBJECT
public:
    FileTransfer(QWidget *parent = 0, const char *name = 0);
    ~FileTransfer();

    void showlist();
    void hidelist();
    void addListView(const QString & sFileCookie, const QString & sID, 
				const QString & sFile, const qlonglong nSize, bool bSend);
    void cancelTransfer( const QString & sFileCookie );
    Q3ListViewItem *getListViewItem( const QString & sFileCookie );

private slots:
    void slotUpdateInfo();
    void updateProgressByByte(const QString& sFileCookie, const qlonglong nByte);
    void endProgressByByte( const QString& sFileCookie );
    void slotCancelButton();

signals:
    void progressUpdate( int progress );
    void cancelFileTransfer( const QString & );
};

#endif
