/***************************************************************************
 *   Copyright (C) 2008 by SK Communications.                              *
 *   http://kldp.net/projects/nateon/                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _MESSAGEBOXWIDGET_H_
#define _MESSAGEBOXWIDGET_H_

#include <kapplication.h>
#include <qlayout.h>
#include <qlabel.h>
//Added by qt3to4:
#include <Q3CString>
#include <QVBoxLayout>
#include <kdebug.h>
#include <qtabwidget.h>
#include <q3filedialog.h>
#include <qinputdialog.h>
#include <qcombobox.h>
#include <klocale.h>
#include <krun.h>
#include <q3popupmenu.h>
#include <kmessagebox.h>

#include "messageboxwidgetbase.h"
#include "listviews.h"
#include "dialog/searchdialogbase.h"
#include "utils.h"

class SearchForm;
class SQLiteDB;

class messageboxWidget : public messageboxWidgetBase {
    Q_OBJECT

public:
    messageboxWidget(QWidget* parent = 0, const char* name = 0, Qt::WFlags fl = 0 );
    ~messageboxWidget();
    /*$PUBLIC_FUNCTIONS$*/

    void requireDBPath();

    ListViews*    pListViews;
    ListViews*    pListViews_2;
    QVBoxLayout*  Widget8Layout;
    QVBoxLayout*  Widget9Layout;
    SQLiteDB      *pDB;
    QString       sDBPath;
    QString       sMemoInboxDBFilePath;
    QString       sMemoOutboxDBFilePath;
    QString       sChatBoxDBFilePath;
    QString       sUserDBFilePath;

    SearchForm    *pMemoSearch;
    SearchForm    *pChatSearch;

    void setUNREAD( Q3ListViewItem* item );
    void setREAD( Q3ListViewItem* item );
    QString getNameByID( QString sID );
    void showMemoAllInbox();
    void showMemoAllOutbox();
    void showChatAllList();

    void showMemoInbox( const Q3CString & sQuery );
    void showMemoOutbox( const Q3CString & sQuery );
    void showChatList( const Q3CString & sQuery );

protected:
    int getNewMemoCount();

public slots:
    virtual void button_clicked();
    void slotChatSearch( int nIdx, const QString & sKey );
    void slotMouseRight( int nId );

    /*! 메모 툴바 */
    void slotMemoWrite();
    void slotMemoReply();
    void slotMemoReplyAll();
    void slotMemoForward();
    void slotMemoDelete();
    void slotMemoFind();
    void slotMemoRefresh();
    void slotMemoHelp();
    void slotMemoSave();

    /*! 대화 툴바 */
    void slotGoChat();
    void slotChatSave();
    void slotChatDelete();
    void slotChatFind();
    void slotChatRefresh();
    void slotChatHelp();

protected slots:
    void slotMemoSearch( int nIdx, const QString & sKey );
    void slotListing( const QString &sDBPath );



    void slotShowMemoInbox();
    void slotShowMemoOutbox();
    void slotShowChatBox();

    void slotSetUNREAD( Q3ListViewItem* item );
    void slotSetREAD( Q3ListViewItem* item );
    void slotChangeTab( QWidget *wg );
    void slotChatMouseRight( int nId );
    void slotDoubleClick( Q3ListViewItem *pItem, const QPoint & mPoint, int nID);
    void slotMemoView( const QString &sUUID );

    void slotMultiItemsSelectedEnv( bool bMultiSelected );

signals:
    void doubleClicked( const QString & );
    void changeShowTab( int );
};

#endif

