<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: uninstall.php,v 1.10 2004/01/23 02:48:33 lseeker Exp $
 */

require 'lib/admin.inc'; // 관리자 환경설정 include
include 'lib/message.inc'; // 메시지 function

header('Content-Type: text/html; charset=UTF-8');

if (!$admin['login']) {
    // 쿠키가 맞지 않는다면...
    PrintMessage("<br>관리자 쿠키를 찾을 수 없습니다.", "error");
    exit;
}


if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!empty($_POST['uninstall_password']) && crypt($_POST['uninstall_password'], $admin_data['passwd']) == $admin_data['passwd']) {
        // 비번이 딱 맞는다면.. 게시판 삭제 -_-;

        /****************************************************
        1: DELETE LOCAL FILE/DIR
        ****************************************************/

        echo "파일을 삭제하는 중입니다 ........ ";
        unlink('db/index.html');

        if ($diropen = opendir('db/ico/')) {
            while(false !== ($file = readdir($diropen))) { 
                if ($file != "." && $file != "..") unlink("db/ico/" . $file);
            }
            closedir($diropen);
        }

        if ($diropen = opendir('db/img/')) {
            while(false !== ($file = readdir($diropen))) { 
                if ($file != "." && $file != "..") unlink("db/img/" . $file);
            }
            closedir($diropen);
        }

        rmdir("db/ico");
        rmdir("db/img");

        echo "<b>완료.</b><br>";

        // dbconn.php 퍼미션 조정: 666 (삭제 가능하게..)
        chmod('db/dbconn.php', 0666);
        unlink('db/dbconn.php');

        /****************************************************
        2: DELETE TABLE
        ****************************************************/
        echo "▷ 데이터베이스에서 관련 정보를 삭제중입니다 ........ ";

        // query to database
        DB::query("DROP TABLE hboard_db_article", $dbconn);
        DB::query("DROP TABLE hboard_db_comment", $dbconn);
        DB::query("DROP TABLE hboard_db_admin", $dbconn);
        // close db connection
        DB::close($dbconn);

        echo "<b>완료.</b><br>";

        /****************************************************
        3: COMPLETE
        ****************************************************/
        echo "<br><font size=2>▶ <b>EtchiBBS를 시스템에서 제거하였습니다.</b><br>"
        ."<font color=#990000>이제 <b>FTP에 접속하셔서 게시판 디렉토리를 삭제</b>하시면 언인스톨이 모두 완료됩니다.</font><br>";
        exit;
    } else {
        // 비번이 맞지 않는다면....;
        PrintMessage("비밀번호가 올바르지 않습니다!", "error");
        exit;
    }
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
<head>
 <title>EtchiBBS Uninstall :: Confirm</title>
 <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
 <link href="internal.css" rel="stylesheet" type="text/css">
 <script type="text/javascript">
<!--
function del_confirm(form) {
    if(form.uninstall_password.value == '') {
        alert('비밀번호가 비어 있습니다!');
        form.uninstall_password.focus();
        return false;
    }

    return true;
}
//-->
 </script>
</head>

<body>
<div id="login">
 <div id="logintop">
  <h1><span class="red">EtchiBBS 설치 제거: 경고</span></h1>
 </div>
 <p class="center">
 <strong>모든 게시물과 환경 설정이 삭제됩니다!</strong>
 <pre>
설치 제거(언인스톨)는 다음 요소들을 삭제할 것입니다.

- db 디렉토리 안의 모든 내용 (아이콘과 그림 파일 전부)
- hboard_db_article, hboar_db_admin, hboard_db_comment
  테이블 내의 모든 내용 (글 데이터와 관리자 환경 설정)

설치 제거 후에도 게시판 디렉토리는 보존됩니다.
(처음 게시판을 설치할 때와 같은 방법으로 재설치가 가능합니다)

게시판 설치 제거를 취소하시려면, 아래 비밀번호 입력칸 옆쪽에 위치한
"취소" 버튼을 클릭하셔서, 관리자 모드로 되돌아갈 수 있습니다.
</pre>
 </p>
 <form method="post" action="uninstall.php" onsubmit="return del_confirm(this);">
  <p class="center">
  <span class="blue">관리자 비밀번호</span>를 입력하신 후, [확인]을 누르시면 설치 제거를 시작합니다.
  </p>
  <p class="center">
  <label>비밀번호: <input type="password" name="uninstall_password" size="14" /></label>
  <input type="submit" value="확인" />
  <input type="button" value="취소" onclick="history.back();">
  </p>
 </form>
</div>
</body>
</html>
