/*
 * Created on 2004. 2. 18.
 *
 */

package net.narusas.daap.server;

import java.io.*;
import java.util.*;
import net.narusas.daap.server.util.Utils;

/**
 * @author Jisung, Ahn
 *  
 */
public class DaapRequest {

	private int _contentLength;
	private boolean _isGzip;
	private String _method;
	private String _uri; 
	private String _http;
	Properties params = new Properties();
	private ArrayList _meta;
	private String _sessionId;
	private int _revision;
	private String _response;
	private static final String SERVER_INFO = "/server-info";
	private static final String LOGIN = "/login";
	private static final String CONTENT_CODES = "/content-codes";
	private static final String UPDATE = "/update";
	private static final String DATABASES_INFO = "/databases?";
	private static final String DATABASES_DATA = "/databases/";
	private static final String CONTAINERS_PLAYLIST = "/containers?";
	private static final String CONTAINERS_MUSIC = "/containers/";
	private static final String SONG_LIST = "/items?";
	private static final String GET_SONG = "/items/";
	private String _database;
	private String _container;
	private String _mp3;
	private boolean _update;

	public DaapRequest(InputStream in) throws Exception {
		parse(in);
	}
	public int getContentLengt() {
		return _contentLength;
	}
	public boolean containMeta(String targetMeta) {
		return _meta.contains(targetMeta);
	}
	public String[] getMetas() {
		return _meta.size() == 0 ? null : (String[]) _meta.toArray(new String[0]);
	}
	public String getSessionId() {
		return _sessionId;
	}
	public int getRevision() {
		return _revision;
	}
	public String getResponse() {
		return _response;
	}
	/**
	 * @param in
	 */
	private void parse(InputStream in) throws Exception {
		_contentLength = 0;
		_isGzip = false;
		boolean isFirstLine = true;
		while (true) {
			String line = readLine(in);
			if (isFirstLine) {
				isFirstLine = false;
				StringTokenizer tokens = new StringTokenizer(line);
				_method = tokens.nextToken();
				_uri = tokens.nextToken();
				_http = tokens.nextToken();
				parseURI(_uri);
			}
			if (line.startsWith("Content-Length:")) {
				_contentLength = Integer
						.parseInt(line.substring("Content-Length:".length()).trim());
			}
			if (line.startsWith("Content-Encoding: gzip")) {
				_isGzip = true;
			}
			if ("".equals(line)) {
				break;
			}
		}
	}
	/**
	 * @param _uri2
	 */
	private void parseURI(String uri) {
		parseRequestedURI(uri);
		parseParams(uri);
	}
	/**
	 * @param uri
	 */
	private void parseRequestedURI(String uri) {
		// parse Request URI
		String requested = null;
		if (uri.indexOf("?") != -1) {
			requested = uri.substring(0, uri.indexOf("?") + 1);
		}
		else {
			requested = uri;
		}
		StringTokenizer tokens = new StringTokenizer(requested, "/?");
		if (requested.equalsIgnoreCase(SERVER_INFO)) {
			_response = "MSRV";
		}
		else if (requested.equalsIgnoreCase(LOGIN)) {
			_response = "MLOG";
		}
		else if (requested.equalsIgnoreCase(CONTENT_CODES)) {
			_response = "MCCR";
		}
		else if (requested.startsWith(UPDATE)) {
			if (requested.indexOf("delta") == -1) {
				_response = "MUPD";
			}
			else {
				_response = "BLANK()";
			}
		}
		else if (requested.startsWith(DATABASES_INFO)) {
			_response = "AVDB";
		}
		else if (requested.startsWith(DATABASES_DATA)) {
			if (requested.indexOf(SONG_LIST) > -1 && requested.indexOf(CONTAINERS_MUSIC) == -1) {
				_response = "ADBS";
				tokens.nextToken(); // skip "database"
				_database = tokens.nextToken();
			}
			// Playlist or music info
			else if (requested.indexOf(CONTAINERS_PLAYLIST) > -1) {
				_response = "APLY";
				tokens.nextToken(); // skip "database"
				_database = tokens.nextToken();
			}
			else if (requested.indexOf(CONTAINERS_MUSIC) > -1 && requested.indexOf(SONG_LIST) > -1) {
				_response = "APSO";
				tokens.nextToken(); // skip "database"
				_database = tokens.nextToken();
				tokens.nextToken(); // skip "container"
				_container = tokens.nextToken();
			}
			else if (requested.indexOf(GET_SONG) > -1) {
				_response = "MP3D";
				tokens.nextToken(); // skip "database"
				_database = tokens.nextToken();
				tokens.nextToken(); // skip "items"
				String temp = tokens.nextToken();
				_mp3 = temp.substring(0, temp.indexOf('.'));
				
			}
		}
	}
	/**
	 * @param uri
	 */
	private void parseParams(String uri) {
		_update = false;
		// parse Params
		if (uri.indexOf("?") == -1) {
			return;
		}
		StringTokenizer tokens = new StringTokenizer(uri.substring(uri.indexOf("?") + 1), "&");
		while (tokens.hasMoreTokens()) {
			String param = tokens.nextToken();
			String name = param.substring(0, param.indexOf("="));
			String value = param.substring(param.indexOf("=") + 1);
			params.setProperty(name, value);
			if ("meta".equals(name)) {
				parseMeta(value);
			}
			if ("session-id".equals(name)) {
				_sessionId = value;
			}
			if ("revision-number".equals(name)) {
				_revision = Integer.parseInt(value);
			}
			if ("delta".equals(name)) {
				_update = true;
			}
		}
	}
	/**
	 * @param value
	 */
	private void parseMeta(String metaValue) {
		_meta = new ArrayList();
		StringTokenizer tokens = new StringTokenizer(metaValue, ",");
		while (tokens.hasMoreTokens()) {
			_meta.add(tokens.nextToken());
		}
	}
	/**
	 * @param in
	 * @return
	 */
	private String readLine(InputStream in) throws IOException {
		return Utils.readLine(in, new byte[1024]);
	}
	/**
	 * @return
	 */
	public String getDatabase() {
		return _database;
	}
	/**
	 * @return
	 */
	public String getPlaylist() {
		return _container;
	}
	/**
	 * @return
	 */
	public String getMP3() {
		return _mp3;
	}
	public boolean isNewUpdate() {
		return _update;
	}
}
